using System;
using System.Data;
using System.Data.SqlClient;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{	
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>10/11/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Encapsulates DB data retrieval logic for the prolonged transfusion time report.</summary>

	#endregion

	public class ProlongedTransfusionReport
	{
		private ProlongedTransfusionReport() {}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5791"> 
		///		<ExpectedInput>Appropriate date range (start date is before the end date) and valid division code.</ExpectedInput>
		///		<ExpectedOutput>
		///			Non-null result - DataTable; no exception is thrown. It is not feasible to predict how many 
		///			records will the report return without fully replicating it in unit tests. It is not also 
		///			practically possible to set up a unit test that will create set of data providing deterministic result.
		///		</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5830"> 
		///		<ExpectedInput>Bad date range (start date is after the end date) and valid division code.</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5841"> 
		///		<ExpectedInput>Valid start and end dates; reverse chronological sort order.</ExpectedInput>
		///		<ExpectedOutput>Report data is sorted in reverse chronological order.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5842"> 
		///		<ExpectedInput>Valid start and end dates; issue-to location sort order.</ExpectedInput>
		///		<ExpectedOutput>Report data is sorted in issue-to location sort order.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5792"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Retrieves prolonged transfusion time report. Does not validate input datetime range, 
		/// if the range is invalid (start date is after the end date) it will return empty <see cref="DataTable"/>.
		/// </summary>
		/// <param name="reportStartDate">Report start date.</param>
		/// <param name="reportEndDate">Report end date.</param>
		/// <param name="delayedTransfusionTimeThresholdMinutes">Threshold in minutes for delayed transfusion time.</param>
		/// <param name="sortOrder">Report sort order.</param>
		/// <returns><see cref="DataTable"/> containing data for the report.</returns>
		public static DataTable GetReportData( DateTime reportStartDate, DateTime reportEndDate, int delayedTransfusionTimeThresholdMinutes, ProlongedTransfusionTimeReportSortOrder sortOrder )
		{
			SqlParameter[] _prms = 
			{
				new SqlParameter( VbecsStoredProcs.GetProlongedTransfusionTimeReport.startdate, SqlDbType.DateTime ),
				new SqlParameter( VbecsStoredProcs.GetProlongedTransfusionTimeReport.enddate, SqlDbType.DateTime ),
				new SqlParameter( VbecsStoredProcs.GetProlongedTransfusionTimeReport.delayedtransfusiontimethresholdminutes, SqlDbType.Int ),
				new SqlParameter( VbecsStoredProcs.GetProlongedTransfusionTimeReport.divisioncode, SqlDbType.Char ),
				new SqlParameter( VbecsStoredProcs.GetProlongedTransfusionTimeReport.sortorder, SqlDbType.Int )
			};

			_prms[0].Value = reportStartDate;
			_prms[1].Value = reportEndDate;
			_prms[2].Value = delayedTransfusionTimeThresholdMinutes;
			_prms[3].Value = Common.LogonUser.LogonUserDivisionCode;
			_prms[4].Value = (int)sortOrder;

			return StoredProcedure.GetDataTable( VbecsStoredProcs.GetProlongedTransfusionTimeReport.StoredProcName, _prms );
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/28/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5888"> 
		///		<ExpectedInput>Valid date range.</ExpectedInput>
		///		<ExpectedOutput>No exception is thrown, non-negative integer.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5890"> 
		///		<ExpectedInput>Invalid date range (start date is after the end date).</ExpectedInput>
		///		<ExpectedOutput>0.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5889"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves record count for the prolonged transfusion time report. 
		/// </summary>
		/// <param name="reportStartDate">Report start date.</param>
		/// <param name="reportEndDate">Report end date.</param>
		/// <param name="delayedTransfusionTimeThresholdMinutes">Threshold in minutes for delayed transfusion time.</param>
		/// <returns>Record count for prolonged transfusion time report.</returns>
		public static int GetReportCountEstimate( DateTime reportStartDate, DateTime reportEndDate, int delayedTransfusionTimeThresholdMinutes )
		{
			SqlParameter[] _prms = 
			{
				new SqlParameter( VbecsStoredProcs.GetProlongedTransfusionTimeReportCount.startdate, SqlDbType.DateTime ),
				new SqlParameter( VbecsStoredProcs.GetProlongedTransfusionTimeReportCount.enddate, SqlDbType.DateTime ),
				new SqlParameter( VbecsStoredProcs.GetProlongedTransfusionTimeReportCount.delayedtransfusiontimethresholdminutes, SqlDbType.Int ),
				new SqlParameter( VbecsStoredProcs.GetProlongedTransfusionTimeReportCount.divisioncode, SqlDbType.Char )
			};

			_prms[0].Value = reportStartDate;
			_prms[1].Value = reportEndDate;
			_prms[2].Value = delayedTransfusionTimeThresholdMinutes;
			_prms[3].Value = Common.LogonUser.LogonUserDivisionCode;

			return new StoredProcedure().GetIntReturnValue( VbecsStoredProcs.GetProlongedTransfusionTimeReportCount.StoredProcName, _prms );
		}
	}
}
